package gov.va.med.mhv.sm.admin.jpa.repository;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import gov.va.med.mhv.sm.admin.jpa.model.ClinicianTriageMap;

@Repository
public interface ClinicianTriageMapRepository extends JpaRepository<ClinicianTriageMap, Long>{
	
	@Query("select ctm from ClinicianTriageMap ctm where ctm.triageGroupId=:triageGroupId")
	List<ClinicianTriageMap> getClinicianTriageMapsByTriageGroup(@Param("triageGroupId") Long triageGroupId);
	
	
	@Query(value="Select u.USER_ID, u.FIRST_NAME, u.LAST_NAME, u.DUZ from CLINICIAN_TRIAGE_MAP ctm, "
			+ "SMS_USER u where u.USER_ID = ctm.USER_ID and ctm.triage_group_id = :triageGroupId", 
			nativeQuery=true)
	List<Object[]> getCliniciansByTriageGroup(@Param("triageGroupId") Long triageGroupId);
	
}